 ; Ŀ
 ;   Fluke - text and attribute isolator.                                  
 ;   Copyright 1994, 1995, 2007 by Rocket Software Ltd.                    
 ;   A stroke of luck, not something that eats your liver.                 
 ; 

 ; Ŀ
 ;   Subroutine Isolde - chop around an entity.                            
 ;   Takes three arguments: the list returned by (textbox), the entity     
 ;   data list, and the cut distance.                                      
 ; 
 (DEFUN ISOLDE (tblst entt cutdis / pwidth rota cc dd bheigt bwidth llangg
               lldist ll ul lr ur outdis lll uul llr uur indis inll inul inlr
                                                                inur plin osm)
  (setq pwidth (getvar "plinewid"))
  (setvar "plinewid" 0)
  (setq rota (cdr (assoc 50 entt)))
  (setq cc (car tblst))                    ; ll offset from 10 of text
  (setq dd (cadr tblst))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
  (setq outdis (* (sqrt 2) cutdis bheigt))
  (setq lll (polar ll (+ rota (* pi 1.25)) outdis))
  (setq uul (polar ul (+ rota (* pi 0.75)) outdis))
  (setq llr (polar lr (+ rota (* pi 1.75)) outdis))
  (setq uur (polar ur (+ rota (* pi 0.25)) outdis))
  (setq indis (* 0.01 bheigt))
  (setq inll (polar lll (+ rota (* pi 0.25)) indis))
  (setq inul (polar uul (+ rota (* pi 1.75)) indis))
  (setq inlr (polar llr (+ rota (* pi 0.75)) indis))
  (setq inur (polar uur (+ rota (* pi 1.25)) indis))
  (setq osm (getvar "osmode"))
  (setvar "osmode" 0)
  (command "pline" lll uul uur llr "c")
  (setq plin (entlast))
  (command "trim" "l" "" "f" inll inul inur inlr inll "" "")
  (setvar "osmode" osm)
  (entdel plin)
  (redraw (cdr (assoc -1 entt)))
  (setvar "plinewid" pwidth)
 (princ))
 ; Ŀ
 ;   Isolde end.                                                           
 ; 

 ; Ŀ
 ;   Fluke - the composer.                                                 
 ; 
 (DEFUN C:FLUKE (/ enampt entt enam typ invis bb blnam blok namm)
  (setvar "cmdecho" 0)
  (if (/= (type cutdis) 'REAL)
      (setq cutdis 0.25))
  (setq enampt (entsel "Text/block: "))
  (if enampt (setq entt (entget (setq enam (car enampt)))))
  (setq typ (cdr (assoc 0 entt)))
  (if (or (= typ "TEXT")
          (= typ "DIMENSION")
          (= typ "INSERT"))
      (progn
           (if (equal prenam enam)
               (setq cutdis (+ cutdis 0.25))
               (setq cutdis 0.25))
           (setq prenam enam)))
  (setq invis 0)                               ; invisible attribute counter
  (cond ((= typ "TEXT")
         (if (setq bb (textbox entt))
             (isolde bb entt cutdis)))
        ((= typ "INSERT")
         (if (assoc 66 entt)
             (while (/= (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))) "SEQEND")
                    (setq stra (cdr (assoc 1 entt)))
                    (while (= (substr stra 1 1) " ")
                           (setq stra (substr stra 2)))
                    (if (/= 1 (logand 1 (cdr (assoc 70 entt))))
                        (if (and (/= stra "")
                                 (setq bb (textbox entt)))
                            (isolde bb entt cutdis))
                        (setq invis (1+ invis))))
             (prompt "\nNo attributes found."))
         (if (> invis 0)
             (prompt (strcat "\n" (itoa invis) " invisible attribute"
                             (if (> invis 1) "s" "") " ignored."))))
        ((= typ "DIMENSION")
         (setq blnam (cdr (assoc 2 entt)))
         (setq blok (tblsearch "block" blnam))      ; get head entity
         (setq namm (cdr (assoc -2 blok)))          ; first ename after head
         (while (and (setq namm (entnext namm))     ; while there is an entity
                      (/= "TEXT" (cdr (assoc 0 (setq entt (entget namm)))))))
         (setq bb (textbox entt))
         (isolde bb entt cutdis))
        (T
          (prompt "\nThis program needs either a block or text.")
          (prompt "\nThat was a fruit bat.")))
 (princ))